<?php include './index.php'; ?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Application Form</title>
       <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
<h1>Job Application Form</h1>


<div class="section"> 
    <h2>Select Advertisement</h2> 
    <select id="projects" name="selectedProject" required> 
        <option value="">Select Job</option> 
    </select> 
</div>

<form id="jobApplicationForm">
    <div class="section">
        <h2>Personal Information</h2>
        <label for="name">Name:</label>
        <input type="text" id="name" name="name" required>
        <label for="fatherName">Father's Name:</label>
        <input type="text" id="fatherName" name="fatherName" required>
        <label for="address">Address:</label>
        <textarea id="address" name="address" required></textarea>
        <label for="domicile">Domicile:</label>
        <input type="text" id="domicile" name="domicile" required>
        <label for="cnic">CNIC:</label>
        <input type="text" id="cnic" name="cnic" required pattern="\d{5}-\d{7}-\d{1}">
        <label for="phoneNumber">Phone Number:</label>
        <input type="text" id="phoneNumber" name="phoneNumber" required pattern="(\+92|92|0)\d{9}">
    </div>

    <div class="section">
        <h2>Qualifications</h2>
        <div id="qualificationForm">
            <label for="degree">Degree:</label>
            <input type="text" id="degree" name="degree[]" required>
            <label for="institution">University/Board:</label>
            <input type="text" id="institution" name="institution[]" required>
            <label for="yearOfCompletion">Year of Completion:</label>
            <input type="number" id="yearOfCompletion" name="yearOfCompletion[]" required>
            <label for="totalMarks">Total Marks:</label>
            <input type="number" id="totalMarks" name="totalMarks[]" required>
            <label for="obtainedMarks">Obtained Marks:</label>
            <input type="number" id="obtainedMarks" name="obtainedMarks[]" required>
            <label for="grade">Grade:</label>
            <input type="text" id="grade" name="grade[]" required>
            <button type="button" id="addQualification">Add Qualification</button>
        </div>

        <table id="qualificationsTable">
            <thead>
                <tr>
                    <th>Degree</th>
                    <th>University/Board</th>
                    <th>Year of Completion</th>
                    <th>Total Marks</th>
                    <th>Obtained Marks</th>
                    <th>Grade</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Qualifications will be added here -->
            </tbody>
        </table>
    </div>

    <div class="section">
        <h2>Experience</h2>
        <div id="experienceForm">
            <label for="jobTitle">Job Title:</label>
            <input type="text" id="jobTitle" name="jobTitle[]" required>
            <label for="organization">Organization:</label>
            <input type="text" id="organization" name="organization[]" required>
            <label for="startDate">Start Date:</label>
            <input type="date" id="startDate" name="startDate[]" required>
            <label for="endDate">End Date:</label>
            <input type="date" id="endDate" name="endDate[]" required>
            <label for="responsibilities">Responsibilities:</label>
            <textarea id="responsibilities" name="responsibilities[]" required></textarea>
            <button type="button" id="addExperience">Add Experience</button>
        </div>

        <table id="experiencesTable">
            <thead>
                <tr>
                    <th>Job Title</th>
                    <th>Organization</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Responsibilities</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Experiences will be added here -->
            </tbody>
        </table>
    </div>

    <button type="submit">Submit</button>
    <div id="successMessage">Message:</div>
</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {

    // Function to load projects
    function loadProjects() {
        var projectType = 'Job';

        $.post('fetch_projectsforJob.php', { p_type: projectType }, function(data) {
            var projects = JSON.parse(data);
            var projectSelect = $('#projects');
            projectSelect.empty().append('<option value="">Select Project</option>');
            projects.forEach(function(project) {
                var option = $('<option>').val(project.ID).text(project.full_subject + ' (' + project.starting_date + ')');
                projectSelect.append(option);
            });
        });
    }

    // Call the function on document ready
    loadProjects();

    // Add qualification
    $('#addQualification').click(function() {
        var degree = $('#degree').val();
        var institution = $('#institution').val();
        var yearOfCompletion = $('#yearOfCompletion').val();
        var totalMarks = $('#totalMarks').val();
        var obtainedMarks = $('#obtainedMarks').val();
        var grade = $('#grade').val();
 
        var newRow = `<tr>
            <td>${degree}</td>
            <td>${institution}</td>
            <td>${yearOfCompletion}</td>
            <td>${totalMarks}</td>
            <td>${obtainedMarks}</td>
            <td>${grade}</td>
            <td><button type="button" class="editQualification">Edit</button> <button type="button" class="deleteQualification">Delete</button></td>
        </tr>`;

        $('#qualificationsTable tbody').append(newRow);

        // Clear form fields
        $('#degree, #institution, #yearOfCompletion, #totalMarks, #obtainedMarks, #grade').val('');

        // Edit button handler
        $('.editQualification').off('click').on('click', function() {
            var row = $(this).closest('tr');
            $('#degree').val(row.find('td:eq(0)').text());
            $('#institution').val(row.find('td:eq(1)').text());
            $('#yearOfCompletion').val(row.find('td:eq(2)').text());
            $('#totalMarks').val(row.find('td:eq(3)').text());
            $('#obtainedMarks').val(row.find('td:eq(4)').text());
            $('#grade').val(row.find('td:eq(5)').text());
            row.remove();
        });

        // Delete button handler
        $('.deleteQualification').off('click').on('click', function() {
            $(this).closest('tr').remove();
        });
    });

    // Add experience
    $('#addExperience').click(function() {
        var jobTitle = $('#jobTitle').val();
        var organization = $('#organization').val();
        var startDate = $('#startDate').val();
        var endDate = $('#endDate').val();
        var responsibilities = $('#responsibilities').val();

        var newRow = `<tr>
            <td>${jobTitle}</td>
            <td>${organization}</td>
            <td>${startDate}</td>
            <td>${endDate}</td>
            <td>${responsibilities}</td>
            <td><button type="button" class="editExperience">Edit</button> <button type="button" class="deleteExperience">Delete</button></td>
        </tr>`;

        $('#experiencesTable tbody').append(newRow);

        // Clear form fields
        $('#jobTitle, #organization, #startDate, #endDate, #responsibilities').val('');

        // Edit button handler
        $('.editExperience').off('click').on('click', function() {
            var row = $(this).closest('tr');
            $('#jobTitle').val(row.find('td:eq(0)').text());
            $('#organization').val(row.find('td:eq(1)').text());
            $('#startDate').val(row.find('td:eq(2)').text());
            $('#endDate').val(row.find('td:eq(3)').text());
            $('#responsibilities').val(row.find('td:eq(4)').text());
            row.remove();
        });

        // Delete button handler
        $('.deleteExperience').off('click').on('click', function() {
            $(this).closest('tr').remove();
        });
    });

    // Handle form submission
    $('#jobApplicationForm').submit(function(event) {
        event.preventDefault();
        var formData = $(this).serialize();
        
        $.post('submit_job_application.php', formData, function(response) {
            $('#successMessage').show(); // Show success message
            setTimeout(function() {
                $('#successMessage').hide();
            }, 3000); // Hide after 3 seconds
            $('#jobApplicationForm')[0].reset();
            $('#qualificationsTable tbody').empty();
            $('#experiencesTable tbody').empty();
        }).fail(function() {
            alert('Error submitting the application. Please try again.');
        });
    });
});
</script>
</body>
</html>
