<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Announcements</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
    </style>
</head>
<body>

<h1>Manage Announcements</h1>

<!-- Add or Edit Announcement Form -->
<h2 id="formTitle">Add New Announcement</h2>
<form id="announcementForm">
    <input type="hidden" id="announcementId"> <!-- Hidden field to store the ID for editing -->
    <input type="text" id="title" placeholder="Title" required><br><br>
    <textarea id="details" placeholder="Details" required></textarea><br><br>
    <input type="text" id="related_to" placeholder="Related To" required><br><br>
    <button type="submit" id="submitBtn">Add Announcement</button>
</form>

<h2>Existing Announcements</h2>
<table id="announcementTable">
    <thead>
        <tr>
            <th>ID</th>
            <th>Title</th>
            <th>Details</th>
            <th>Related To</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>

<script>
    // Function to load announcements
    function loadAnnouncements() {
        fetch('manage_announcements.php')
            .then(response => response.json())
            .then(data => {
                const tableBody = document.querySelector('#announcementTable tbody');
                tableBody.innerHTML = '';

                data.announcements.forEach(announcement => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${announcement.ID}</td>
                        <td>${announcement.an_titile}</td>
                        <td>${announcement.details}</td>
                        <td>${announcement.related_to}</td>
                        <td>
                            <button onclick="editAnnouncement(${announcement.ID}, '${announcement.an_titile}', '${announcement.details}', '${announcement.related_to}')">Edit</button>
                            <button onclick="deleteAnnouncement(${announcement.ID})">Delete</button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            });
    }

    // Add or Edit Announcement
    document.getElementById('announcementForm').addEventListener('submit', function(event) {
        event.preventDefault();
        
        const title = document.getElementById('title').value;
        const details = document.getElementById('details').value;
        const related_to = document.getElementById('related_to').value;
        const id = document.getElementById('announcementId').value;

        const formData = new FormData();
        const action = id ? 'update' : 'add'; // If ID exists, we are updating

        formData.append('action', action);
        formData.append('id', id);
        formData.append('title', title);
        formData.append('details', details);
        formData.append('related_to', related_to);

        fetch('manage_announcements.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                loadAnnouncements();
                document.getElementById('announcementForm').reset();
                document.getElementById('announcementId').value = ''; // Reset hidden ID
                document.getElementById('formTitle').innerText = 'Add New Announcement'; // Change form title back to 'Add'
                document.getElementById('submitBtn').innerText = 'Add Announcement'; // Change button text
            }
        });
    });

    // Edit announcement (populate the form with data)
    function editAnnouncement(id, title, details, related_to) {
        document.getElementById('announcementId').value = id;
        document.getElementById('title').value = title;
        document.getElementById('details').value = details;
        document.getElementById('related_to').value = related_to;

        // Update form header and button text
        document.getElementById('formTitle').innerText = 'Edit Announcement';
        document.getElementById('submitBtn').innerText = 'Update Announcement';
    }

    // Delete announcement
    function deleteAnnouncement(id) {
        if (confirm('Are you sure you want to delete this announcement?')) {
            const formData = new FormData();
            formData.append('action', 'delete');
            formData.append('id', id);

            fetch('manage_announcements.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    loadAnnouncements();
                }
            });
        }
    }

    // Initial load of announcements
    loadAnnouncements();
</script>

</body>
</html>
