<?php include './index.php'; ?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Constructions</title>
       <link rel="stylesheet" type="text/css" href="style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            fetchConstructions();

            $('#details-form').submit(function(e) {
                e.preventDefault();
                addOrUpdateDetails();
            });

            $('#add-construction-form').submit(function(e) {
                e.preventDefault();
                addConstruction();
            });

            $('#construction-id').change(function() {
                let constructionId = $(this).val();
                if (constructionId) {
                    fetchConstructionDetails(constructionId);
                } else {
                    $('#construction-details-display').html('');
                }
            });
        });

        function fetchConstructions() {
            $.ajax({
                url: 'manage_construction.php?action=fetch',
                method: 'GET',
                success: function(data) {
                    let constructions = JSON.parse(data);
                    let tableHtml = '<table><tr><th>ID</th><th>Title</th><th>Supervision</th><th>Budget</th><th>Start Date</th><th>End Date</th></tr>';
                    let optionsHtml = '<option value="">Select Construction</option>';
                    constructions.forEach(function(construction) {
                        tableHtml += `<tr>
                            <td>${construction.ID}</td>
                            <td>${construction.construction_title}</td>
                            <td>${construction.under_supervision}</td>
                            <td>${construction.assigned_budget}</td>
                            <td>${construction.start_date}</td>
                            <td>${construction.end_date}</td>
                        </tr>`;
                        optionsHtml += `<option value="${construction.ID}">${construction.construction_title}</option>`;
                    });
                    tableHtml += '</table>';
                    $('#constructions').html(tableHtml);
                    $('#construction-id').html(optionsHtml);
                }
            });
        }

        function fetchConstructionDetails(constructionId) {
            $.ajax({
                url: 'manage_construction.php?action=fetch_details&construction_id=' + constructionId,
                method: 'GET',
                success: function(data) {
                    let details = JSON.parse(data);
                    let detailsHtml = '<table><tr><th>ID</th><th>Details Date</th><th>Details</th></tr>';
                    details.forEach(function(detail) {
                        detailsHtml += `<tr>
                            <td>${detail.ID}</td>
                            <td>${detail.details_date}</td>
                            <td>${detail.construction_details}</td>
                        </tr>`;
                    });
                    detailsHtml += '</table>';
                    $('#construction-details-display').html(detailsHtml);
                }
            });
        }

        function addOrUpdateDetails() {
            const constructionId = $('#construction-id').val();
            const detailsDate = $('#details-date').val();
            const constructionDetails = $('#construction-details').val();

            $.ajax({
                url: 'manage_construction.php?action=add_details',
                method: 'POST',
                data: {
                    construction_id: constructionId,
                    details_date: detailsDate,
                    construction_details: constructionDetails
                },
                success: function(response) {
                    alert(response);
                    fetchConstructionDetails(constructionId);
                }
            });
        }

        function addConstruction() {
            const title = $('#construction-title').val();
            const supervision = $('#under-supervision').val();
            const budget = $('#assigned-budget').val();
            const startDate = $('#start-date').val();
            const endDate = $('#end-date').val();

            $.ajax({
                url: 'manage_construction.php?action=add_construction',
                method: 'POST',
                data: {
                    construction_title: title,
                    under_supervision: supervision,
                    assigned_budget: budget,
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    alert(response);
                    fetchConstructions();
                }
            });
        }
    </script>
</head>
<body>
    <h1>Manage Constructions</h1>
   
    <div id="construction-details">
        <form id="details-form">
            <label for="construction-id">Construction Title:</label>
            <select id="construction-id" name="construction-id" required>
                <option value="">Select Construction</option>
            </select><br>
            <label for="details-date">Details Date:</label>
            <input type="date" id="details-date" name="details-date" required><br>
            <label for="construction-details">Details:</label>
            <textarea id="construction-details" name="construction-details" required></textarea><br>
            <button type="submit">Submit</button>
        </form>
    </div>
    <div id="construction-details-display">
        <!-- Table for construction details will be populated by jQuery -->
    </div>
    <div id="add-construction">
        <form id="add-construction-form">
            <label for="construction-title">Construction Title:</label>
            <input type="text" id="construction-title" name="construction-title" required><br>
            <label for="under-supervision">Under Supervision:</label>
            <input type="text" id="under-supervision" name="under-supervision" required><br>
            <label for="assigned-budget">Assigned Budget:</label>
            <input type="number" id="assigned-budget" name="assigned-budget" required><br>
            <label for="start-date">Start Date:</label>
            <input type="date" id="start-date" name="start-date" required><br>
            <label for="end-date">End Date:</label>
            <input type="date" id="end-date" name="end-date" required><br>
            <button type="submit">Add Construction</button>
        </form>
    </div>
     <div id="constructions">
        <!-- Table for constructions will be populated by jQuery -->
    </div>
    
</body>
</html>
