<?php
include '../connection.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

    if ($id > 0) {
        // Retrieve the file path from the database
        $stmt = $conn->prepare("SELECT file_name FROM record_keeper WHERE ID = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->bind_result($file_path);
        $stmt->fetch();
        $stmt->close();

        if ($file_path && file_exists($file_path)) {
            unlink($file_path); // Delete the file from the server

            // Delete the record from the database
            $stmt = $conn->prepare("DELETE FROM record_keeper WHERE ID = ?");
            $stmt->bind_param('i', $id);

            if ($stmt->execute()) {
                echo "Record and file deleted successfully.";
            } else {
                echo "Error: Could not delete the record.";
            }

            $stmt->close();
        } else {
            echo "Error: File not found.";
        }
    } else {
        echo "Error: Invalid ID.";
    }
} else {
    echo "Error: Request method is not POST.";
}
?>
