<?php
include "../connection.php"; // Ensure this points to your database connection file

// Fetch Courts
if (isset($_GET['action']) && $_GET['action'] === 'fetchCourts') {
    $sql = "SELECT ID, court_name FROM district_courts";
    $result = $conn->query($sql);
    $courts = [];
    while ($row = $result->fetch_assoc()) {
        $courts[] = $row;
    }
    echo json_encode($courts);
    exit;
}

// Fetch Pendency Data
if (isset($_GET['action']) && $_GET['action'] === 'fetchPendency') {
    $sql = "SELECT p.ID, p.Date_From, p.Date_to, p.pendency_type, p.institution, p.transfer_out, p.disposed, p.pending, c.court_name
            FROM tbl_performance p
            JOIN district_courts c ON p.court_id = c.ID";
    $result = $conn->query($sql);
    $pendencyData = [];
    while ($row = $result->fetch_assoc()) {
        $pendencyData[] = $row;
    }
    echo json_encode($pendencyData);
    exit;
}

// Fetch Single Pendency for Editing
if (isset($_GET['action']) && $_GET['action'] === 'fetchSinglePendency' && isset($_GET['ID'])) {
    $ID = $_GET['ID'];
    $sql = "SELECT * FROM tbl_performance WHERE ID = '$ID'";
    $result = $conn->query($sql);
    $record = $result->fetch_assoc();
    echo json_encode($record);
    exit;
}

// Handle Insert/Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['action'])) {
    if (isset($_POST['ID']) && !empty($_POST['ID'])) { // Update
        $ID = $_POST['ID'];
        $court_id = $_POST['court_id'];
        $Date_From = $_POST['Date_From'];
        $Date_to = $_POST['Date_to'];
        $pendency_type = $_POST['pendency_type'];
        $institution = $_POST['institution'];
        $transfer_out = $_POST['transfer_out'];
        $disposed = $_POST['disposed'];
        $pending = $_POST['pending'];

        $sql = "UPDATE tbl_performance SET court_id='$court_id', Date_From='$Date_From', Date_to='$Date_to', 
                pendency_type='$pendency_type', institution='$institution', transfer_out='$transfer_out', 
                disposed='$disposed', pending='$pending' WHERE ID='$ID'";
    } else { // Insert
        // Check for duplicate entry
        $court_id = $_POST['court_id'];
        $Date_From = $_POST['Date_From'];
        $Date_to = $_POST['Date_to'];
        $pendency_type = $_POST['pendency_type'];
        $institution = $_POST['institution'];
        $transfer_out = $_POST['transfer_out'];
        $disposed = $_POST['disposed'];
        $pending = $_POST['pending'];

        $check_sql = "SELECT * FROM tbl_performance WHERE court_id = '$court_id' AND Date_From = '$Date_From' AND Date_to = '$Date_to' AND pendency_type='$pendency_type'";
        $check_result = $conn->query($check_sql);
        if ($check_result->num_rows > 0) {
            echo "Record already exists!";
            exit;
        }

        $sql = "INSERT INTO tbl_performance (court_id, Date_From, Date_to, pendency_type, institution, transfer_out, disposed, pending) 
                VALUES ('$court_id', '$Date_From', '$Date_to', '$pendency_type', '$institution', '$transfer_out', '$disposed', '$pending')";
    }

    if ($conn->query($sql)) {
        echo "Record successfully saved!";
    } else {
        echo "Error: " . $conn->error;
    }
    exit;
}

// Handle Delete
if (isset($_POST['action']) && $_POST['action'] === 'deletePendency' && isset($_POST['delete_id'])) {
    $delete_id = $_POST['delete_id'];
    $sql = "DELETE FROM tbl_performance WHERE ID = '$delete_id'";

    if ($conn->query($sql)) {
        echo "Record deleted successfully!";
    } else {
        echo "Error deleting record: " . $conn->error;
    }
    exit;
}
?>
