<?php session_start();
  if( $_SESSION["admin"]!=true)
  {
    header("location:login.php");
    exit;
  }?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Insert Data</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <h2>Insert Civil Court Official Data</h2>
    <form id="dataForm">
        <div>
            <label for="official_name">Official Name</label>
            <input type="text" id="official_name" name="official_name" placeholder="Official Name" required>
        </div>
        <div>
            <label for="appointment_date">Appointment Date</label>
            <input type="date" id="appointment_date" name="appointment_date" required>
        </div>
        <div>
            <label for="intial_designation">Initial Designation</label>
            <select id="intial_designation" name="intial_designation" required>
                 <option value="Superintendent">Superintendent</option>
             <option value="Junior Scale Stenographer">Junior Scale Stenographer</option>
                <option value="Senior Scale Stenographer">Senior Scale Stenographer</option>
                <option value="Assistant">Assistant</option>
                <option value="Computer Operator">Computer Operator</option>
                <option value="Sweeper">Sweeper</option>
                <option value="Senior Clerk">Senior Clerk</option>
                <option value="Junior Clerk">Junior Clerk</option>
                <option value="Bailiff">Bailiff</option>
                <option value="Process Server">Process Server</option>
                <option value="Naib Nazar">Naib Nazar</option>
                <option value="Civil Nazar">Civil Nazar</option>
                <option value="COC">COC</option>
                <option value="Naib Qasid">Naib Qasid</option>
                <option value="Mali">Mali</option>
                <option value="Daftari">Daftari</option>
                <option value="Chowkidar">Chowkidar</option>
                <option value="Accountant">Accountant</option>
                <option value="Execution Muharrir">Execution Muharrir</option>
                <!-- Add more options as needed -->
            </select>
        </div>
        <div>
            <label for="current_designation">Current Designation</label>
            <select id="current_designation" name="current_designation" required>
                 <option value="Superintendent">Superintendent</option>
                    <option value="Junior Scale Stenographer">Junior Scale Stenographer</option>
                <option value="Senior Scale Stenographer">Senior Scale Stenographer</option>
                <option value="Assistant">Assistant</option>
                <option value="Computer Operator">Computer Operator</option>
                <option value="Sweeper">Sweeper</option>
                <option value="Senior Clerk">Senior Clerk</option>
                <option value="Junior Clerk">Junior Clerk</option>
                <option value="Bailiff">Bailiff</option>
                <option value="Process Server">Process Server</option>
                <option value="Naib Nazar">Naib Nazar</option>
                <option value="Civil Nazar">Civil Nazar</option>
                <option value="COC">COC</option>
                <option value="Naib Qasid">Naib Qasid</option>
                <option value="Mali">Mali</option>
                <option value="Daftari">Daftari</option>
                <option value="Chowkidar">Chowkidar</option>
                <option value="Accountant">Accountant</option>
                <option value="Execution Muharrir">Execution Muharrir</option>
            </select>
        </div>
        <div>
            <label for="PersonalNumber">Personal Number</label>
            <input type="text" id="PersonalNumber" name="PersonalNumber" required>
        </div>
        <div>
            <label for="date_of_birth">Date of Birth</label>
            <input type="date" id="date_of_birth" name="date_of_birth" required>
        </div>
        <div>
            <label for="address">Address</label>
            <input type="text" id="address" name="address" required>
        </div>
        <div>
            <label for="contact_number">Contact Number</label>
            <input type="text" id="contact_number" name="contact_number" required>
        </div>
        <input type="hidden" id="update_id" name="update_id" value=""> <!-- Hidden input for update -->
        <input type="submit" value="Submit">
    </form>
    
    <div id="message"></div>

    <h3>Search and View Records</h3>
    <input type="text" id="search" placeholder="Search by official name or designation">
    <table id="dataTable">
        <thead>
            <tr>
                <th>Official Name</th>
                <th>Appointment Date</th>
                <th>Initial Designation</th>
                <th>Current Designation</th>
                <th>Date of Birth</th>
                <th>Personal Number</th>
                <th>Address</th>
                <th>Contact Number</th>
                <th>Actions</th> <!-- Action column for Update -->
            </tr>
        </thead>
        <tbody>
            <!-- Data will be populated by JavaScript -->
        </tbody>
    </table>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
     $(document).ready(function() {
    // Handle form submission via AJAX
    $('#dataForm').on('submit', function(event) {
        event.preventDefault(); // Prevent default form submission

        $.ajax({
            url: './update_officials.php', // PHP file for processing form data
            method: 'POST',
            data: $(this).serialize(), // Serialize form data for AJAX submission
            success: function(response) {
                alert(response); // Show the response from PHP (success or error)
                fetchData(); // Reload the table after submission
                $('#dataForm')[0].reset(); // Reset the form
                $('#update_id').val(''); // Clear the hidden field for update
            },
            error: function(xhr, status, error) {
                alert('Error: ' + error); // Show an error message if AJAX fails
            }
        });
    });

    // Fetch the data for the table after page load
    function fetchData() {
        $.ajax({
            url: './fetchofficialsdata.php?type=data', // URL to fetch data from the database
            method: 'GET',
            success: function(data) {
                $('#dataTable tbody').html(data); // Populate table with data
            }
        });
    }

    // Handle search functionality
    $('#search').on('keyup', function() {
        var searchValue = $(this).val().toLowerCase();
        $('#dataTable tbody tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(searchValue) > -1);
        });
    });

    // Edit row - when the Update button is clicked
    $(document).on('click', '.update-btn', function() {
        var id = $(this).data('id'); // Get the ID of the record to update

        // Fetch data for the specific record using AJAX
        $.ajax({
            url: './fetchofficialsdata.php', // Fetch specific official data
            method: 'GET',
            data: { type: 'singleData', id: id }, // Send the ID to fetch specific data
            success: function(response) {
                var data = JSON.parse(response); // Parse the JSON response

                // Populate the form with the fetched data
                if (data.error) {
                    alert(data.error);
                } else {
                    $('#official_name').val(data.official_name);
                    $('#appointment_date').val(data.appointment_date);
                    $('#initial_designation').val(data.intial_designation);
                    $('#current_designation').val(data.current_designation);
                    $('#PersonalNumber').val(data.PersonalNumber);
                    $('#date_of_birth').val(data.date_of_birth);
                    $('#address').val(data.address);
                    $('#contact_number').val(data.contact_number);
                    $('#update_id').val(data.ID); // Set the hidden field for update
                }
            },
            error: function(xhr, status, error) {
                alert('Error: ' + error);
            }
        });
    });

    fetchData(); // Fetch initial data for the table
});

    </script>
</body>
</html>
