<?php
include('../connection.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $official_id = $_POST['official_id'];
    $qualification_title = $_POST['qualification_title'];
    $grade = $_POST['grade'];
    $degree_date = $_POST['degree_date'];

    // Check for duplicate records
    $check_sql = "SELECT * FROM officials_qualifications WHERE official_id=? AND qualification_title=? ";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("sss", $official_id, $qualification_title);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<span style='color: red;'>Error: Duplicate qualification record found.</span>";
    } else {
        $sql = "INSERT INTO officials_qualifications (official_id, qualification_title, grade, degree_date) 
                VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $official_id, $qualification_title, $grade, $degree_date);

        if ($stmt->execute()) {
            echo "<span style='color: green;'>Qualification added successfully.</span>";
        } else {
            echo "<span style='color: red;'>Error: " . $stmt->error . "</span>";
        }
    }

    $stmt->close();
    $conn->close();
}
?>
