<?php
// Secure database connection.
include 'connection.php';
include 'header.php'; // Include the header for consistent styling
?>

<div class="container-fluid bg-white p-0">
    <div class="container py-5">
        <h2 class="mb-4">Upload a New Publication</h2>
        <form action="process_upload.php" method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="title" class="form-label">Title:</label>
                <input type="text" class="form-control" id="title" name="title" required>
            </div>
            <div class="mb-3">
                <label for="author" class="form-label">Author:</label>
                <input type="text" class="form-control" id="author" name="author">
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">Description:</label>
                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>
            <div class="mb-3">
                <label for="file" class="form-label">Upload PDF File:</label>
                <input type="file" class="form-control" id="file" name="file" accept=".pdf" required>
                <small class="form-text text-muted">Only PDF files are allowed.</small>
            </div>
            <button type="submit" class="btn btn-primary">Submit Publication</button>
        </form>
    </div>
</div>

<?php
include 'footer.php'; // Include the footer
?>