<?php
session_start();

if (!isset($_SESSION["Logdin"]) || $_SESSION["Logdin"] !== true) {
    header("location:login.php");
    exit;
}

// Include configuration files
require_once "./connection.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Users</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
        }
        .wrapper {
            width: 100%;
            max-width: 400px;
            padding: 20px;
            margin: 100px auto;
            background-color: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
        }
        h1 {
            margin-bottom: 20px;
            color: #333333;
        }
        .form-control {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
        }
        .form-control:focus {
            border-color: #80bdff;
            outline: none;
        }
        .btn {
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            border: none;
            border-radius: 4px;
            color: white;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <form action="./signup_php.php" method="post">
            <h1>Add New Users</h1><br>
            <select name="user_type" class="form-control">
                <option value="admin">Admin</option>
                <option value="official">Official</option>
            </select>
            <input type="text" name="username" class="form-control" placeholder="User Name" required>
            <input type="password" name="upassword" class="form-control" placeholder="Password" required>
            <input type="password" name="cpass" class="form-control" placeholder="Confirm Password" required>
            <input type="submit" value="Sign Up" class="btn">
            <p>To Login Please <a href="login.php">Click Here!</a></p>
        </form>
    </div>
</body>
</html>
