

<!DOCTYPE html>
<html>
<head>
    <title>Court Statistics</title>
    <!-- Include necessary CSS and JavaScript libraries for charting (e.g., Chart.js) -->
    <link rel="stylesheet" type="text/css" href="path/to/chart.css">
    <script src="path/to/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <h1>Court Statistics</h1>
    <label for="courtSelect">Select a Court: </label>
    <select id="courtSelect">
        <?php
        require_once 'connection.php';

        $query = "SELECT * from courts";
        $result = mysqli_query($conn, $query);

        while ($row = mysqli_fetch_assoc($result)) {
            echo "<option value='" . $row['ID'] . "'>" . $row['courtname'] . "</option>";
        }

        mysqli_close($conn);
        ?>
    </select>

    <div id="chartContainer">
        <!-- The chart will be displayed here -->
    </div>

    <script>
        $(document).ready(function () {
            $('#courtSelect').change(function () {
                const selectedCourt = $(this).val();
                $.ajax({
                    url: 'fetch_statistics.php',
                    method: 'GET',
                    data: { court_id: selectedCourt },
                    dataType: 'json',
                    success: function (data) {
                        createChart(data);
                    },
                    error: function (error) {
                        console.error('Error fetching data:', error);
                    }
                });
            });

            function createChart(data) {
                const ctx = document.getElementById('chartContainer').getContext('2d');
                const chart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: ['Total Pendency', 'Total Disposal', 'Total Institution'],
                        datasets: [{
                            label: 'Court Statistics',
                            data: [data.total_pendency, data.total_disposal, data.total_institution],
                            backgroundColor: ['blue', 'green', 'orange'],
                        }]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            }
        });
        
        
        
        console.log('Selected Court: ' + selectedCourt);

$.ajax({
    url: 'fetch_statistics.php',
    method: 'GET',
    data: { court_id: selectedCourt },
    dataType: 'json',
    success: function (data) {
        console.log('Received Data:', data);
        createChart(data);
    },
    error: function (error) {
        console.error('Error fetching data:', error);
    }
});

        
        
    </script>
</body>
</html>

