<?php
// This line includes your universal header, including the navigation and all CSS.
include 'header.php';
?>

<div class="container-xxl p-0">
  
    <div class="container">
     
        <input type="text" id="searchJudgmentsInput" placeholder="Search Judgments..." class="form-control" onkeyup="searchJudgments()">

        <p id="noJudgmentsMessage" style="display: none; color: red;">No judgments found.</p>

        <table id="judgmentsTable" class="table table-bordered" style="display: none;">
            <thead>
                <tr>
                    <th>Officer</th>
                    <th>Case Number</th>
                    <th>Case Type</th>
                    <th>Judgment Date</th>
                </tr>
            </thead>
            <tbody>
                </tbody>
        </table>
    </div>

    <div class="container">
        <p>Search Books, MOD's, Books or Other Documents</p>
        <input type="text" id="searchDocumentsInput" class="form-control" placeholder="Search for documents..." onkeyup="searchContent()">
    </div>

    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                <h6 class="section-title text-center text-primary text-uppercase">Necessary Files For Public</h6>
            </div><br><br>

            <?php
            // The connection is already established in header.php, no need to include it again.
            $stmt = $conn->prepare("SELECT DISTINCT `record_category` FROM `record_keeper`");
            $stmt->execute();
            $categoryResult = $stmt->get_result();

            if ($categoryResult && $categoryResult->num_rows > 0) {
                while ($categoryRow = $categoryResult->fetch_assoc()) {
                    $category = $categoryRow["record_category"];
                    echo '<h2>' . htmlspecialchars($category) . '</h2>';
                    $stmt2 = $conn->prepare("SELECT `ID`, `record_subject`, `record_category`, `record_date`, `file_name` FROM `record_keeper` WHERE `record_category` = ? ORDER BY ID DESC");
                    $stmt2->bind_param("s", $category);
                    $stmt2->execute();
                    $result2 = $stmt2->get_result();

                    if ($result2 && $result2->num_rows > 0) {
                        while ($row2 = $result2->fetch_assoc()) {
                            echo '<div class="record-item">';
                            echo '<p class="record-subject">' . htmlspecialchars($row2["record_subject"]) . ' <a href="./Administrator/uploads/Downloads/' . htmlspecialchars($row2["file_name"]) . '" target="_blank">View/Download</a></p>';
                            echo '</div>';
                        }
                    } else {
                        echo '<p>No records available in this category.</p>';
                    }
                    $stmt2->close();
                }
            } else {
                echo '<p>No categories found.</p>';
            }
            $stmt->close();
            ?>
        </div>
    </div>
</div>

<script>
    function searchJudgments() {
        var query = $('#searchJudgmentsInput').val().trim();

        if (query === '') {
            $('#judgmentsTable').hide();
            $('#noJudgmentsMessage').hide();
            return;
        }

        $.ajax({
            url: 'loadjudgment.php',
            type: 'GET',
            data: { searchQuery: query },
            success: function(response) {
                if (response.trim() === '') {
                    $('#judgmentsTable').hide();
                    $('#noJudgmentsMessage').show();
                } else {
                    $('#judgmentsTable tbody').html(response);
                    $('#judgmentsTable').show();
                    $('#noJudgmentsMessage').hide();
                }
            },
            error: function() {
                console.error('Error loading data.');
            }
        });
    }

    function searchContent() {
        var input = document.getElementById('searchDocumentsInput').value.toLowerCase();
        var content = document.querySelectorAll('.record-item');

        content.forEach(function (item) {
            var subject = item.querySelector('.record-subject').textContent.toLowerCase();

            if (subject.includes(input)) {
                item.style.display = '';
            } else {
                item.style.display = 'none';
            }
        });
    }
</script>

<?php
// This line includes your universal footer, including all JS libraries and closing tags.
include 'footer.php';
?>