  <?php
// Include the universal header file
include_once 'header.php';

// Include the database connection file only once
include_once 'connection.php';
?>

<style>
    /* Your existing CSS for officer cards */
    .officer-card {
        border: none;
        border-radius: 15px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }

    .officer-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.12);
    }

    .officer-img {
        width: 140px;
        height: 140px;
        border-radius: 50%;
        object-fit: cover;
        border: 5px solid #fff;
        margin-top: -70px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .card-body h5 {
        font-family: 'Montserrat', sans-serif;
        font-weight: 600;
    }

    .officer-designation {
        color: var(--primary);
        font-weight: 500;
    }
</style>

<div class="container-xxl py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
 
            <h3 class="mb-5">Meet Our <span class="text-primary text-uppercase">Judicial Officers</span></h3>
        </div>
        
      
        <div class="row g-4 justify-content-center" id="officerList">
            <?php
            // Use JOIN to fetch related data from both tables using prepared statements
            $stmt = $conn->prepare("SELECT po.ID, po.officer_name, po.officer_status, po.pic_path, dc.court_name 
                                   FROM presiding_officers po
                                   JOIN district_courts dc ON po.court_id = dc.ID ");
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result && $result->num_rows > 0) {
                $delay = 0.1;
                while ($row = $result->fetch_assoc()) {
                    
                    // Set default image if pic_path is empty or file doesn't exist
                    $picPath = !empty($row["pic_path"]) && file_exists("./Administrator/" . $row["pic_path"]) ? "./Administrator/" . htmlspecialchars($row["pic_path"]) : "img/default-avatar.png";

                    // Determine status and badge color
                    $status = ($row["officer_status"] == 1) ? 'Present' : 'Transferred';
 

                    echo '
                    <div class="col-lg-3 col-md-4 col-sm-6 wow fadeInUp officer-item" data-wow-delay="' . $delay . 's">
                        <div class="card officer-card shadow-sm text-center">
                            <div class="card-header bg-light border-0" style="height: 100px;"></div>
                            <img src="' . $picPath . '" class="officer-img mx-auto" alt="' . htmlspecialchars($row["officer_name"]) . '">
                            <div class="card-body pt-2">
                                <h5 class="card-title mb-1 officer-name">' . htmlspecialchars($row["officer_name"]) . '</h5>
                                <p class="card-text officer-designation mb-2">' . htmlspecialchars($row["court_name"]) . '</p>
                        
                            </div>
                        </div>
                    </div>';
                    
                    $delay += 0.2;
                }
            } else {
                echo '<div class="col-12 text-center" id="noOfficersMessage">
                        <p>No judicial officers found.</p>
                      </div>';
            }

            $stmt->close();
            $conn->close();
            ?>
        </div>
    </div>
</div>

<script>
    function filterJudicial() {
        var input = document.getElementById('judicialSearch').value.toLowerCase();
        var officerItems = document.querySelectorAll('.officer-item');
        var found = false;

        officerItems.forEach(function (item) {
            var name = item.querySelector('.officer-name').textContent.toLowerCase();
            var courtName = item.querySelector('.officer-designation').textContent.toLowerCase();
            
            if (name.includes(input) || courtName.includes(input)) {
                item.style.display = '';
                found = true;
            } else {
                item.style.display = 'none';
            }
        });

        var noOfficersMessage = document.getElementById('noOfficersMessage');
        if (noOfficersMessage) {
            noOfficersMessage.style.display = found ? 'none' : 'block';
        } else if (!found) {
            var noResultsHtml = '<div class="col-12 text-center" id="noOfficersMessage"><p>No judicial officers found matching your search.</p></div>';
            document.getElementById('officerList').insertAdjacentHTML('afterbegin', noResultsHtml);
        }
    }
</script>

<?php
// Include the universal footer file
include 'footer.php';
?>