<?php
// Include the shared header file
// This will include connection.php and the header HTML
include 'header.php'; 
?>

<div class="container-fluid py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h6 class="section-title text-center text-primary text-uppercase">Our Activities</h6>
            <h1 class="mb-5">News & <span class="text-primary text-uppercase">Events Archive</span></h1>
        </div>

        <div class="row g-4">
            <?php
            // Your existing secure PHP code for fetching and displaying news/events
            // This is the only part of the code that is unique to this page.
            
            $sql = "SELECT `ID`, `event_title`, `event_date`, `event_place`, `event_details`, `event_type`, `event_pic` FROM `events` ORDER BY `event_date` DESC";
            $stmt = $conn->prepare($sql);

            if (!$stmt) {
                die("Prepare failed: " . $conn->error);
            }

            $stmt->execute();
            $result = $stmt->get_result();

            if ($result && $result->num_rows > 0) {
                $delay = 0.1;
                while ($row = $result->fetch_assoc()) {
                    $event_title = htmlspecialchars($row['event_title'] ?? 'No Title');
                    $event_date = htmlspecialchars($row['event_date'] ?? 'No Date');
                    $event_place = htmlspecialchars($row['event_place'] ?? 'No Place');
                    $event_details = htmlspecialchars($row['event_details'] ?? 'No details available.');
                    $event_type = htmlspecialchars($row['event_type'] ?? 'General');
                    $event_pic = htmlspecialchars($row['event_pic'] ?? '');

                    $pic_path = 'Administrator/uploads/Events/' . $event_pic;
                    if (empty($event_pic) || !file_exists($pic_path)) {
                        $pic_path = 'img/default-event.jpg';
                    }
                    
                    echo '
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="' . htmlspecialchars($delay) . 's">
                        <div class="card event-card shadow-sm">
                            <div class="card-img-container">
                                <img src="' . htmlspecialchars($pic_path) . '" class="card-img-top" alt="' . $event_title . '">
                                <span class="badge bg-primary event-type-badge">' . ucfirst($event_type) . '</span>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title mb-3">' . $event_title . '</h5>
                                <p class="text-muted event-info mb-2"><i class="bi bi-calendar-event me-2 text-primary"></i>' . date("F j, Y", strtotime($event_date)) . '</p>
                                <p class="text-muted event-info mb-3"><i class="bi bi-geo-alt-fill me-2 text-primary"></i>' . $event_place . '</p>
                                <p class="card-text text-muted small">' . mb_strimwidth($event_details, 0, 100, "...") . '</p>
                            </div>
                        </div>
                    </div>';
                    $delay += 0.1;
                }
            } else {
                echo '<div class="col-12 text-center text-muted wow fadeInUp" data-wow-delay="0.1s">
                        <p>There are no news or events to display at the moment.</p>
                    </div>';
            }
            $stmt->close();
            $conn->close();
            ?>
        </div>
    </div>
</div>
<?php
// Include the shared footer file
include 'footer.php';
?>