<?php
// Secure database connection.
include 'connection.php';
include 'header.php';
?>

<div class="container-fluid bg-white py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h1 class="mb-5">Legal Research & Publications</h1>
        </div>
        <div class="row g-4">
            <div class="col-lg-12">
                <?php
                // Fetch publications from the database
                $stmt = $conn->prepare("SELECT title, author, description, filename, upload_date FROM publications ORDER BY upload_date DESC");
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                ?>
                        <div class="card mb-4 wow fadeInUp">
                            <div class="card-body">
                                <h4 class="card-title"><?= htmlspecialchars($row['title']) ?></h4>
                                <p class="card-text text-muted small">
                                    Published: <?= date('F j, Y', strtotime($row['upload_date'])) ?> | Author: <?= htmlspecialchars($row['author']) ?>
                                </p>
                                <p class="card-text"><?= htmlspecialchars($row['description']) ?></p>
                                <a href="publications/<?= htmlspecialchars($row['filename']) ?>" class="btn btn-primary" target="_blank" download>Download PDF</a>
                            </div>
                        </div>
                <?php
                    }
                } else {
                    echo "<p>No publications found.</p>";
                }
                $stmt->close();
                ?>
            </div>
        </div>
    </div>
</div>

<?php
include 'footer.php';
$conn->close();
?>