<?php
session_start();
// Database connection
include '../connection.php';

// Check if admin is logged in
if ($_SESSION["admin"] != true) {
    header("location:login.php");
    exit;
}?>



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Events</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <h1>Manage Events</h1>

    <h2>Add Event</h2>
    <form id="addEventForm" enctype="multipart/form-data">
        <label for="uploadType">Upload Type:</label>
        <select id="uploadType" name="uploadType" required>
            <option value="news">News</option>
            <option value="event">Event</option>
        </select>

        <label for="eventTitle">Event Title:</label>
        <input type="text" id="eventTitle" name="eventTitle" required>

        <label for="eventDate">Event Date:</label>
        <input type="date" id="eventDate" name="eventDate" required>

        <label for="eventPlace">Event Place:</label>
        <input type="text" id="eventPlace" name="eventPlace" required>

        <label for="eventDetails">Event Details:</label>
        <textarea id="eventDetails" name="eventDetails" required></textarea>

        <div id="eventImageSection" style="display: none;">
            <label for="eventImage">Event Image:</label>
            <input type="file" id="eventImage" name="eventImage" accept="image/jpeg, image/png">
        </div>

        <button type="submit">Add Event</button>
    </form>
    <div id="eventResponseMessage"></div>

    <h2>Existing Events</h2>
    <table id="eventsTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Date</th>
                <th>Place</th>
                <th>Details</th>
                <th>Type</th>
                <th>Image</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        fetchEvents();

        $("#addEventForm").submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: 'manage_events.php?action=addEvent',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    $("#eventResponseMessage").text(response);
                    fetchEvents();
                },
                error: function(xhr, status, error) {
                    console.error("Error:", error);
                }
            });
        });

        $("#uploadType").change(function() {
            if ($(this).val() === 'event') {
                $("#eventImageSection").show();
            } else {
                $("#eventImageSection").hide();
            }
        });

        function fetchEvents() {
            $.get('manage_events.php', { action: 'getEvents' }, function(data) {
                var events = JSON.parse(data);
                var tableContent = '';
                events.forEach(function(event) {
                    tableContent += `
                        <tr>
                            <td>${event.ID}</td>
                            <td>${event.event_title}</td>
                            <td>${event.event_date}</td>
                            <td>${event.event_place}</td>
                            <td>${event.event_details}</td>
                            <td>${event.event_type}</td>
                            <td>${event.event_type === 'event' ? `<img src="../uploads/Events/${event.event_pic}" alt="Image" width="100">` : 'N/A'}</td>
                            <td>
                                <button class="delete-button" data-id="${event.ID}">Delete</button>
                            </td>
                        </tr>
                    `;
                });
                $("#eventsTable tbody").html(tableContent);
            });
        }

        $(document).on('click', '.delete-button', function() {
            const id = $(this).data('id');
            if (confirm('Are you sure?')) {
                $.post('manage_events.php', { action: 'deleteEvent', id: id }, function(response) {
                    alert(response);
                    fetchEvents();
                }).fail(function(xhr, status, error) {
                    console.error("Error:", error);
                });
            }
        });
    });
    </script>
</body>
</html>
