<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Pendency</title>
    <style>
        /* Basic styles for the form and table */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            text-align: center;
        }
        form {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        form label {
            display: block;
            margin: 5px 0;
        }
        form input, form select {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        button {
            padding: 10px 15px;
            background-color: #5c6bc0;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #3f51b5;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        button.editBtn, button.deleteBtn {
            padding: 5px 10px;
            background-color: #ff5722;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button.editBtn:hover, button.deleteBtn:hover {
            background-color: #e64a19;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Manage Pendency</h1>
        
        <!-- Form to Add/Update Pendency -->
        <form id="pendencyForm">
            <label for="court_id">Court:</label>
            <select id="court_id" name="court_id" required>
                <option value="">Select Court</option>
            </select><br>

            <label for="Date_From">Date From:</label>
            <input type="date" id="Date_From" name="Date_From" required><br>

            <label for="Date_to">Date To:</label>
            <input type="date" id="Date_to" name="Date_to" required><br>

            <label for="pendency_type">Pendency Type:</label>
            <select id="pendency_type" name="pendency_type" required>
                <option value="Civil">Civil</option>
                <option value="Criminal">Criminal</option>
            </select><br>

            <label for="institution">Institution:</label>
            <input type="text" id="institution" name="institution" required><br>

            <label for="transfer_out">Transfer Out:</label>
            <input type="number" id="transfer_out" name="transfer_out" required><br>

            <label for="disposed">Disposed:</label>
            <input type="number" id="disposed" name="disposed" required><br>

            <label for="pending">Pending:</label>
            <input type="number" id="pending" name="pending" required><br>

            <button type="submit" id="submitBtn">Submit</button>
        </form>

        <!-- Table to Display Pendency Data -->
        <table id="pendencyTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Court</th>
                    <th>Date From</th>
                    <th>Date To</th>
                    <th>Pendency Type</th>
                    <th>Institution</th>
                    <th>Transfer Out</th>
                    <th>Disposed</th>
                    <th>Pending</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be dynamically inserted here -->
            </tbody>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            // Fetch Court List
            function fetchCourts() {
                $.ajax({
                    url: 'manage_pendency.php',
                    type: 'GET',
                    data: { action: 'fetchCourts' },
                    success: function(data) {
                        let courts = JSON.parse(data);
                        $('#court_id').html('<option value="">Select Court</option>');
                        courts.forEach(function(court) {
                            $('#court_id').append(`<option value="${court.ID}">${court.court_name}</option>`);
                        });
                    }
                });
            }

            // Function to fetch pendency data and update the table
            function fetchPendencyData() {
                $.ajax({
                    url: 'manage_pendency.php',
                    type: 'GET',
                    data: { action: 'fetchPendency' },
                    success: function(data) {
                        let pendencyData = JSON.parse(data);
                        $('#pendencyTable tbody').empty(); // Clear the table body before appending new rows
                        pendencyData.forEach(function(record) {
                            $('#pendencyTable tbody').append(`
                                <tr>
                                    <td>${record.ID}</td>
                                    <td>${record.court_name}</td>
                                    <td>${record.Date_From}</td>
                                    <td>${record.Date_to}</td>
                                    <td>${record.pendency_type}</td>
                                    <td>${record.institution}</td>
                                    <td>${record.transfer_out}</td>
                                    <td>${record.disposed}</td>
                                    <td>${record.pending}</td>
                                    <td>
                                        <button class="editBtn" data-id="${record.ID}">Edit</button>
                                        <button class="deleteBtn" data-id="${record.ID}">Delete</button>
                                    </td>
                                </tr>
                            `);
                        });
                    },
                    error: function(xhr, status, error) {
                        alert('Error fetching data: ' + error);
                    }
                });
            }

            // Submit Form for Insert/Update
            $('#pendencyForm').submit(function(e) {
                e.preventDefault();
                let formData = $(this).serialize();

                $.ajax({
                    url: 'manage_pendency.php',
                    type: 'POST',
                    data: formData,
                    success: function(response) {
                        alert(response);
                        fetchPendencyData(); // Refresh the table after operation
                        $('#pendencyForm')[0].reset();
                    }
                });
            });

            // Edit Button Click
            $(document).on('click', '.editBtn', function() {
                let ID = $(this).data('id');
                $.ajax({
                    url: 'manage_pendency.php',
                    type: 'GET',
                    data: { action: 'fetchSinglePendency', ID: ID },
                    success: function(data) {
                        let record = JSON.parse(data);
                        $('#court_id').val(record.court_id);
                        $('#Date_From').val(record.Date_From);
                        $('#Date_to').val(record.Date_to);
                        $('#pendency_type').val(record.pendency_type);
                        $('#institution').val(record.institution);
                        $('#transfer_out').val(record.transfer_out);
                        $('#disposed').val(record.disposed);
                        $('#pending').val(record.pending);
                        $('#submitBtn').text('Update');
                    }
                });
            });

            // Delete Button Click
            $(document).on('click', '.deleteBtn', function() {
                let ID = $(this).data('id');
                if (confirm('Are you sure you want to delete this record?')) {
                    $.ajax({
                        url: 'manage_pendency.php',
                        type: 'POST',
                        data: {
                            action: 'deletePendency', // This action triggers the delete functionality
                            delete_id: ID // Pass the ID of the record to be deleted
                        },
                        success: function(response) {
                            alert(response);  // Show the success or error message from PHP
                            fetchPendencyData(); // Refresh the table after deletion
                        },
                        error: function(xhr, status, error) {
                            alert('Error deleting record: ' + error);
                        }
                    });
                }
            });

            // Initial Calls to Load Data
            fetchCourts();
            fetchPendencyData();
        });
    </script>
</body>
</html>
