<?php
include '../connection.php'; // Ensure this path is correct for your setup

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Prepare the SQL statement with a parameterized query to prevent SQL injection
    // Sort records by starting date, closest to the current date
    $stmt = $conn->prepare("SELECT `ID`, `full_subject`, `starting_date`, `ending_date` 
                            FROM `recruitments`
                            ORDER BY `starting_date` ASC");  // Ascending order to get the nearest date first

    $stmt->execute();
    $result = $stmt->get_result();

    $projects = [];
    // Fetch the results and store them in an array
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $projects[] = $row;
        }
    } else {
        // Handle case where no projects are found
        echo json_encode([]);
        exit;
    }

    // Encode the array as a JSON object and echo it
    echo json_encode($projects);

    // Close the statement and connection
    $stmt->close();
    $conn->close();
}
?>
