<?php include './index.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Recruitments</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <h1>Manage Recruitments</h1>
    <form id="recruitmentForm" enctype="multipart/form-data">
        <label for="full_subject">Full Subject:</label>
        <input type="text" id="full_subject" name="full_subject" required>

        <label for="starting_date">Starting Date:</label>
        <input type="date" id="starting_date" name="starting_date" required>

        <label for="ending_date">Ending Date:</label>
        <input type="date" id="ending_date" name="ending_date" required>

        <label for="file_location">File Location (PDF):</label>
        <input type="file" id="file_location" name="file_location" accept=".pdf" required>

        <button type="submit">Submit</button>
    </form>

    <div id="response"></div>
    
    <div class="progress">
        <div class="progress-bar" id="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
    </div>
    
    <h2>Recruitments List</h2>
    <table id="recruitmentsTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Full Subject</th>
                <th>Starting Date</th>
                <th>Ending Date</th>
                <th>File Location</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data will be inserted here by JavaScript -->
        </tbody>
    </table>

    <style>
    .progress {
        width: 100%;
        background-color: #f3f3f3;
    }

    .progress-bar {
        width: 0%;
        height: 30px;
        background-color: #007bff; /* Blue color */
        text-align: center;
        line-height: 30px;
        color: white;
    }
    </style>

    <script>
document.getElementById('recruitmentForm').addEventListener('submit', function(e) {
    e.preventDefault();
    console.log('Form submitted');

    const formData = new FormData(this);
    formData.append('action', 'insert');

    const xhr = new XMLHttpRequest();
    xhr.upload.addEventListener('progress', function(e) {
        if (e.lengthComputable) {
            const percentComplete = (e.loaded / e.total) * 100;
            const progressBar = document.getElementById('progress-bar');
            progressBar.style.width = percentComplete + '%';
            progressBar.setAttribute('aria-valuenow', percentComplete);
            progressBar.textContent = Math.round(percentComplete) + '%';
            console.log('Progress:', percentComplete);
        }
    });

    xhr.addEventListener('load', function() {
        const response = JSON.parse(xhr.responseText);
        document.getElementById('response').innerHTML = response.message;
        fetchRecruitments();

        const progressBar = document.getElementById('progress-bar');
        progressBar.style.width = '0%';
        progressBar.setAttribute('aria-valuenow', 0);
        progressBar.textContent = '0%';
        console.log('Upload complete');
    });

    xhr.addEventListener('error', function() {
        document.getElementById('response').innerHTML = 'An error occurred. Please try again.';
        console.log('Upload error');
    });

    xhr.open('POST', 'manage_recruitments.php');
    xhr.send(formData);
});

function fetchRecruitments() {
    fetch('manage_recruitments.php')
    .then(response => response.json())
    .then(data => {
        const tableBody = document.getElementById('recruitmentsTable').getElementsByTagName('tbody')[0];
        tableBody.innerHTML = '';

        data.forEach(record => {
            const row = tableBody.insertRow();
            row.insertCell(0).textContent = record.ID;
            row.insertCell(1).textContent = record.full_subject;
            row.insertCell(2).textContent = record.starting_date;
            row.insertCell(3).textContent = record.ending_date;
            row.insertCell(4).innerHTML = '<a href="' + record.file_location + '" target="_blank">Open</a>';

            const actionsCell = row.insertCell(5);

            const deleteButton = document.createElement('button');
            deleteButton.textContent = 'Delete';
            deleteButton.onclick = function() {
                deleteRecruitment(record.ID);
            };
            actionsCell.appendChild(deleteButton);
        });
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function deleteRecruitment(id) {
    const formData = new FormData();
    formData.append('action', 'delete');
    formData.append('id', id);

    fetch('manage_recruitments.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById('response').innerHTML = data.message;
        fetchRecruitments();
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('response').innerHTML = 'An error occurred. Please try again.';
    });
}

document.addEventListener('DOMContentLoaded', function() {
    fetchRecruitments();
});
    </script>
</body>
</html>
