<?php include('./index.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Records</title>
    <link rel="stylesheet" type="text/css" href="./style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        select, input[type="text"], input[type="file"] {
            margin: 10px 0;
            padding: 8px;
            width: 100%;
        }
        .progress {
            width: 100%;
            background-color: #f3f3f3;
        }
        .progress-bar {
            width: 0%;
            height: 30px;
            background-color: #007bff; /* Blue color */
            text-align: center;
            line-height: 30px;
            color: white;
        }
    </style>
</head>
<body>

<h1>Manage Records</h1>

<!-- Form for Uploading Record -->
<h2>Upload New Record</h2>
<form id="uploadForm">
    <input type="text" id="record_subject" placeholder="Enter Record Subject" required><br><br>
    <select id="category" required>
        <option value="">Select Category</option>
        <option value="Public">Public</option>
        <option value="Law Book">Law Book</option>
        <option value="Advertisement">Advertisement</option>
        <option value="Tender">Tender</option>
        <option value="Proforma">Proforma</option>
        <option value="Seniority List">Seniority List</option>
            <option value="MODs">MODs Order</option>
   
        
    </select><br><br>
    <input type="file" id="file" accept=".pdf, .xlsx, .xls" required><br><br>
    <button type="submit">Upload Record</button>
</form>

<div id="response"></div>

<div class="progress">
    <div class="progress-bar" id="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
</div>

<h2>Existing Records</h2>
<table id="recordsTable">
    <thead>
        <tr>
            <th>ID</th>
            <th>Record Subject</th>
            <th>Category</th>
            <th>Date</th>
            <th>File Name</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>

<script>
    // Function to load existing records from the server
    function loadRecords() {
        fetch('manage_uploadfile.php?action=fetch')
            .then(response => response.json())
            .then(data => {
                const tableBody = document.querySelector('#recordsTable tbody');
                tableBody.innerHTML = '';

                data.records.forEach(record => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${record.ID}</td>
                        <td>${record.record_subject}</td>
                        <td>${record.record_category}</td>
                        <td>${record.record_date}</td>
                        <td><a href="../uploads/Downloads/${record.file_name}" target="_blank">${record.file_name}</a></td>
                        <td>
                            <button onclick="deleteRecord(${record.ID})">Delete</button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            });
    }

    // Add new record
    document.getElementById('uploadForm').addEventListener('submit', function(event) {
        event.preventDefault();
        
        const subject = document.getElementById('record_subject').value;
        const category = document.getElementById('category').value;
        const file = document.getElementById('file').files[0];

        const formData = new FormData();
        formData.append('action', 'upload');
        formData.append('record_subject', subject);
        formData.append('record_category', category);
        formData.append('file', file);

        const xhr = new XMLHttpRequest();
        xhr.upload.addEventListener('progress', function(e) {
            if (e.lengthComputable) {
                const percentComplete = (e.loaded / e.total) * 100;
                const progressBar = document.getElementById('progress-bar');
                progressBar.style.width = percentComplete + '%';
                progressBar.setAttribute('aria-valuenow', percentComplete);
                progressBar.textContent = Math.round(percentComplete) + '%';
            }
        });

        xhr.addEventListener('load', function() {
            const response = JSON.parse(xhr.responseText);
            document.getElementById('response').innerHTML = response.message;
            loadRecords();

            const progressBar = document.getElementById('progress-bar');
            progressBar.style.width = '0%';
            progressBar.setAttribute('aria-valuenow', 0);
            progressBar.textContent = '0%';
        });

        xhr.addEventListener('error', function() {
            document.getElementById('response').innerHTML = 'An error occurred. Please try again.';
        });

        xhr.open('POST', 'manage_uploadfile.php');
        xhr.send(formData);
    });

    // Delete a record
    function deleteRecord(id) {
        if (confirm('Are you sure you want to delete this record?')) {
            const formData = new FormData();
            formData.append('action', 'delete');
            formData.append('id', id);

            fetch('manage_uploadfile.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    loadRecords();
                } else {
                    alert('Error: ' + data.message);
                }
            });
        }
    }

    // Load records when the page loads
    window.onload = loadRecords;
</script>

</body>
</html>
