<?php
// Include the shared header file
include 'header.php';
?>

<div class="container-fluid bg-white p-0">
    <div class="container-xxl py-5">
        <div class="container">
            <h1 class="text-center mb-4">Halqa Jat (Administrative Circles) of District Buner, KPK</h1>
            <div class="row g-4">
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Daggar Tehsil</h4>
                        <p class="card-text text-center">The main administrative center of District Buner.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Khudu Khel Tehsil</h4>
                        <p class="card-text text-center">A significant sub-division in the southern part of the district.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Gagra Tehsil</h4>
                        <p class="card-text text-center">Located towards the eastern side of Buner.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.7s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Mandanr Tehsil</h4>
                        <p class="card-text text-center">A prominent circle known for its agricultural areas.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.9s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Chagharzai Tehsil</h4>
                        <p class="card-text text-center">One of the major tehsils in the northern part of Buner.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="1.1s">
                    <div class="card p-4">
                        <h4 class="card-title text-center">Gadezai Tehsil</h4>
                        <p class="card-text text-center">A sub-division with a diverse and historical landscape.</p>
                    </div>
                </div>
            </div>
            
            <hr class="my-5">

            <h2 class="text-center mb-4">List of Process Servers & Bailiffs at District Courts Buner</h2>
            <div class="table-responsive wow fadeInUp" data-wow-delay="0.1s">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>Name</th>
                            <th>Designation</th>
                            <th>Appointment Date</th>
                            <th>Contact</th>
                            <th>Address</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Corrected the user's query to be secure and properly formatted.
                        $sql = "SELECT `official_name`, `current_designation`, `appointment_date`, `contact_number`, `address` 
                                FROM `civil_court_officials` 
                                WHERE `current_designation` = 'Process Server' OR `current_designation` = 'Bailiff'";

                        // Use prepared statement for security
                        if ($stmt = $conn->prepare($sql)) {
                            // No parameters to bind as the query uses static values.
                            $stmt->execute();
                            $result = $stmt->get_result();

                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>";
                                    echo "<td>" . htmlspecialchars($row['official_name']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['current_designation']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['appointment_date']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['contact_number']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['address']) . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo '<tr><td colspan="5" class="text-center">No Process Servers or Bailiffs found.</td></tr>';
                            }
                            $stmt->close();
                        } else {
                            echo '<tr><td colspan="5" class="text-center text-danger">Error preparing the database query.</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
// Include the shared footer file
include 'footer.php';
?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    // Example: A simple script to add a class on scroll for animations
    $(window).scroll(function() {
        $('.wow').each(function(){
            if (isScrolledIntoView($(this))) {
                $(this).addClass('animate__animated animate__fadeInUp');
            }
        });
    });

    function isScrolledIntoView(elem) {
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();
        var elemTop = $(elem).offset().top;
        var elemBottom = elemTop + $(elem).height();
        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    }
</script>
<p>
This video discusses the political dynamics and public sentiment in Buner, offering insight into the local context.
<a href="https://www.youtube.com/watch?v=vBYZmlBDIBQ">Chairman PTI Gohar Khan Ka Apne Ilaqa Me Muqabla Kis Kis Se? Buner Halqa NA-10 Me Vote Kitna Nikla?</a>
</p>
 