<?php
// Include the shared header file to ensure consistent styling and navigation
// The header already includes the database connection.
include 'header.php';
?>

<div class="container-fluid bg-white p-0">
    <div class="container-xxl py-5">
        <div class="container">
            <script type="text/javascript">
                // Function to fetch the cause list for a selected date
                function loadCauseList() {
                    var selectedDate = document.getElementById("cdate").value;
                    var selectedCourt = document.getElementById("courtSelect").value;

                    // Validate if a date is selected
                    if (selectedDate === "") {
                        alert("Please select a Date.");
                        return;
                    }

                    // Creating the XMLHttpRequest object
                    const xmlhttp = new XMLHttpRequest();

                    // Define what to do when data is received
                    xmlhttp.onload = function() {
                        // Update the content of the div with the id 'causeListTable' with the response
                        document.getElementById("causeListTable").innerHTML = this.responseText;
                    };

                    // Sending the request to caselistload.php with both date and court as query parameters
                    xmlhttp.open("GET", "caselistload.php?cdate=" + selectedDate + "&courtid=" + selectedCourt, true);
                    xmlhttp.send();
                }

                // Automatically set today's date and fetch the cause list on page load
                window.onload = function() {
                    // Set today's date in the date input field
                    const today = new Date().toISOString().split("T")[0]; // Get the current date in YYYY-MM-DD format
                    document.getElementById("cdate").value = today;

                    // Trigger the loadCauseList function to fetch today's data
                    loadCauseList();

                    // Add an event listener to the court select dropdown
                    document.getElementById("courtSelect").addEventListener('change', loadCauseList);
                };
            </script>

            <form style="text-align: center;">
                <h3>
                    Courts
                    <b>
                        <select id="courtSelect" style="font-family: 'New Times Roman'; font-size: 15px; border-radius: 7px; border-color: blue; padding-bottom: 6px; padding-top: 4px; width: 250px; margin-left: 15px;">
                            <?php
                            // Since header.php already includes connection.php, we don't need to include it again.
                            $q1 = "SELECT * FROM district_courts";
                            $result = $conn->query($q1);
                            if (!empty($result) && $result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo '<option value="' . $row["ID"] . '">' . $row["court_name"] . '</option>';
                                }
                            }
                            ?>
                        </select>
                    </b>
                    Date
                    <input type="date" id="cdate" required="" style="font-size: 15px; border-radius: 7px; border-color: blue; padding-bottom: 6px; padding-top: 4px; width: 250px; margin-left: 15px;">
                    <button type="button" onclick="loadCauseList()" style="border-radius: 13px; border-color: navy;">Load</button>
                </h3>
            </form>
            <br><br>

            <div id="causeListTable"></div>
        </div>
    </div>
</div>

<?php
// Include the shared footer file
include 'footer.php';
?>