<?php
// This line includes your universal header, including the navigation, all CSS, and the database connection.
include 'header.php';
?>

<style>
    /* Professional Card Styling */
    .tender-card {
        border: none;
        border-radius: 10px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .tender-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .tender-card .card-body {
        padding: 2.5rem;
    }

    .tender-card .card-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--bs-primary);
    }

    .tender-card .card-text i {
        color: var(--bs-secondary);
        margin-right: 0.5rem;
    }
</style>

<div class="container-xxl py-1">
    <div class="container">
   

        <div class="wow fadeInUp" data-wow-delay="0.3s">
            <h3 class="mt-5 mb-4 text-center">Available Jobs & Tenders</h3>
            <div class="row g-4">
                <?php
                // Fetch jobs
                $stmt = $conn->prepare("SELECT `full_subject`, `ending_date`, `file_location` FROM `recruitments` WHERE status = 1 ORDER BY `ending_date` DESC");
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo '<div class="col-lg-6">
                                <div class="card tender-card shadow-sm h-100">
                                    <div class="card-body d-flex flex-column">
                                        <h5 class="card-title">' . htmlspecialchars($row["full_subject"], ENT_QUOTES, 'UTF-8') . '</h5>
                                        <p class="card-text flex-grow-1"><i class="bi bi-calendar"></i> Expire Date: ' . htmlspecialchars($row["ending_date"], ENT_QUOTES, 'UTF-8') . '</p>
                                        <a href="/Administrator/uploads/Jobs/' . htmlspecialchars($row["file_location"], ENT_QUOTES, 'UTF-8') . '" target="_blank" class="btn btn-primary mt-auto">
                                            View & Download <i class="bi bi-download ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                              </div>';
                    }
                } else {
                    echo '<div class="col-12 text-center">
                            <div class="alert alert-info" role="alert">
                                <i class="bi bi-info-circle-fill me-2"></i> No active jobs found at this time.
                            </div>
                          </div>';
                }
                $stmt->close();
                ?>
            </div>
        </div>

        <div class="wow fadeInUp" data-wow-delay="0.5s">
       
            <div class="row g-4">
                <?php
                // Fetch tenders
                $stmt2 = $conn->prepare("SELECT `tender_title`, `tender_date`, `tender_place`, `tender_details`, `file_location` FROM `tenders` WHERE status = 1 ORDER BY `tender_date` DESC");
                $stmt2->execute();
                $result2 = $stmt2->get_result();

                if ($result2->num_rows > 0) {
                    while ($row2 = $result2->fetch_assoc()) {
                        $file_path = str_replace("../uploads/Tenders/", "Administrator/uploads/Tenders/", $row2["file_location"]);
                        
                        echo '<div class="col-lg-6">
                                <div class="card tender-card shadow-sm h-100">
                                    <div class="card-body d-flex flex-column">
                                        <h5 class="card-title">' . htmlspecialchars($row2["tender_title"], ENT_QUOTES, 'UTF-8') . '</h5>
                                        <p class="card-text"><i class="bi bi-calendar"></i> Last Date: ' . htmlspecialchars($row2["tender_date"], ENT_QUOTES, 'UTF-8') . '</p>
                                        <p class="card-text"><i class="bi bi-geo-alt"></i> Place: ' . htmlspecialchars($row2["tender_place"], ENT_QUOTES, 'UTF-8') . '</p>
                                        <p class="card-text flex-grow-1"><i class="bi bi-file-earmark-text"></i> Details: ' . htmlspecialchars($row2["tender_details"], ENT_QUOTES, 'UTF-8') . '</p>
                                        <a href="' . htmlspecialchars($file_path, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="btn btn-primary mt-auto">
                                            View & Download <i class="bi bi-download ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                              </div>';
                    }
                } else {
                    echo '<div class="col-12 text-center">
                            <div class="alert alert-info" role="alert">
                                <i class="bi bi-info-circle-fill me-2"></i> No active tenders found at this time.
                            </div>
                          </div>';
                }
                $stmt2->close();
                $conn->close();
                ?>
            </div>
        </div>
    </div>
</div>

<?php
// This line includes your universal footer, including all JS libraries and closing tags.
include 'footer.php';
?>