<?php
include './connection.php';

// Get the search query
$searchQuery = isset($_GET['searchQuery']) ? $_GET['searchQuery'] : '';

// Prepare the SQL query
$sql = "SELECT `OfficerName`, `CaseNumber`, `CaseType`, `JudgmentDate`, `JudgmentText`
        FROM `judgments`
        WHERE `OfficerName` LIKE ? OR `CaseType` LIKE ?
        ORDER BY `JudgmentDate` DESC";

$stmt = $conn->prepare($sql);
$searchWildcard = '%' . $searchQuery . '%';
$stmt->bind_param("ss", $searchWildcard, $searchWildcard);
$stmt->execute();
$result = $stmt->get_result();

// Generate the table rows
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Replace the beginning of the JudgmentText path
        $updatedPath = str_replace("../uploads/Judgments", "./Administrator/uploads/Judgments", $row['JudgmentText']);

        echo '<tr>';
        echo '<td>' . htmlspecialchars($row['OfficerName']) . '</td>';
        echo '<td>' . htmlspecialchars($row['CaseNumber']) . '</td>';
        echo '<td>' . htmlspecialchars($row['CaseType']) . '</td>';
        echo '<td>' . htmlspecialchars($row['JudgmentDate']) . '</td>';
        echo '<td><a href="' . htmlspecialchars($updatedPath) . '" target="_blank">View Judgment</a></td>';
        echo '</tr>';
    }
} else {
    echo '<tr><td colspan="5">No judgments found.</td></tr>'; // Updated colspan to match the number of columns
}

$stmt->close();
?>
