<?php
// Include the universal header file.
include 'header.php';

// Include the database connection file only once to prevent conflicts.
include_once 'connection.php';
?>

<div class="container-xxl py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h4 class="mb-5 text-primary text-uppercase">MOD Rosters</h4>
 
        </div>


        <div class="row g-4 justify-content-center" id="documentList">
            <?php
            // Prepare a secure query to get only documents with the category 'MODs'
            $query = "SELECT `record_subject`, `file_name`, `record_date` FROM `record_keeper` WHERE `record_category` = 'MODs' ORDER BY `ID` DESC";
            $stmt = $conn->prepare($query);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    ?>
                    <div class="col-lg-8 col-md-10 wow fadeInUp document-item" data-wow-delay="0.3s">
                        <div class="list-group-item d-flex justify-content-between align-items-center p-4 mb-3 border rounded">
                            <div>
                                <h5 class="mb-1 text-primary document-subject">
                                    <?php echo htmlspecialchars($row['record_subject'], ENT_QUOTES, 'UTF-8'); ?>
                                </h5>
                                <small class="text-muted">
                                    Uploaded: <?php echo date("F d, Y", strtotime($row['record_date'])); ?>
                                </small>
                            </div>
                            <a href="./Administrator/uploads/Downloads/<?php echo htmlspecialchars($row['file_name'], ENT_QUOTES, 'UTF-8'); ?>"
                               class="btn btn-primary rounded-pill py-2 px-4" target="_blank" download>
                                <i class="fa fa-download me-2"></i> View/Download
                            </a>
                        </div>
                    </div>
                    <?php
                }
            } else {
                echo '<div class="col-12" id="noDocumentsMessage">
                        <div class="alert alert-info text-center" role="alert">
                            <i class="bi bi-info-circle-fill me-2"></i> No MOD documents are available at this time.
                        </div>
                      </div>';
            }

            $stmt->close();
            $conn->close();
            ?>
        </div>
    </div>
</div>

<script>
    function filterDocuments() {
        var input = document.getElementById('documentSearch').value.toLowerCase();
        var documentItems = document.querySelectorAll('.document-item');
        var found = false;

        documentItems.forEach(function (item) {
            var subject = item.querySelector('.document-subject').textContent.toLowerCase();
            if (subject.includes(input)) {
                item.style.display = '';
                found = true;
            } else {
                item.style.display = 'none';
            }
        });

        var noDocumentsMessage = document.getElementById('noDocumentsMessage');
        if (noDocumentsMessage) {
            if (found) {
                noDocumentsMessage.style.display = 'none';
            } else {
                // If no items are found and the message element exists, show it.
                // This logic handles the case where there were initial results that are now filtered out.
                noDocumentsMessage.style.display = '';
            }
        } else if (!found) {
             // Create and show a "No documents found" message if none exists
            var noResultsHtml = '<div class="col-12" id="noDocumentsMessage"><div class="alert alert-info text-center" role="alert"><i class="bi bi-info-circle-fill me-2"></i> No documents found matching your search.</div></div>';
            document.getElementById('documentList').insertAdjacentHTML('afterbegin', noResultsHtml);
        }
    }
</script>

<?php
// Include the universal footer file
include 'footer.php';
?>