<?php
// Include the universal header file.
include 'header.php';

// Include the database connection file only once to prevent conflicts.
include_once 'connection.php';
?>

<style>
    /* Table-specific styles */
    .staff-table {
        width: 100%;
        margin-top: 2rem;
        border-collapse: collapse;
    }

    .staff-table th, .staff-table td {
        padding: 12px 15px;
        text-align: left;
        vertical-align: middle;
        border-bottom: 1px solid #dee2e6;
    }

    .staff-table thead {
        background-color: #00008B; /* DarkBlue */
        color: #fff;
    }

    .staff-table tbody tr:hover {
        background-color: #f5f5f5;
    }

    .category-row {
        background-color: #e9ecef;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 1.25rem;
        color: #343a40;
    }

    .category-row:hover {
        background-color: #e9ecef !important; /* Prevent hover effect on category rows */
    }

    .staff-name {
        font-weight: 600;
        color: #333;
    }
</style>
<h3 class="mt-5 mb-4 fw-bold text-uppercase text-center">District Courts Buner Ministerial Staff</h3>
 
<div class="container-xxl py-5">
    <div class="container">
      
         
                <input type="text" id="staffSearch" class="form-control form-control-lg" placeholder="Search for staff by name or designation..." onkeyup="filterStaff()">
           
       
        
        <div class="table-responsive wow fadeInUp" data-wow-delay="0.3s">
            <table class="table table-striped table-hover staff-table" id="staffTable">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Designation</th>
                        <th>Contact Number</th>
                        <th>Address</th>
                        <th>Appointment Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Fetch all unique staff designations
                    $stmt = $conn->prepare("SELECT DISTINCT `current_designation` FROM `civil_court_officials` ORDER BY `current_designation` ASC");
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result->num_rows > 0) {
                        // Prepare the second statement with the correct columns
                        $staffStmt = $conn->prepare("SELECT `official_name`, `current_designation`, `contact_number`, `address`, `appointment_date` FROM `civil_court_officials` WHERE `current_designation` = ? ORDER BY `official_name` ASC");
                        
                        while ($designationRow = $result->fetch_assoc()) {
                            $designation = htmlspecialchars($designationRow['current_designation'], ENT_QUOTES, 'UTF-8');
                            
                            // Display a heading row for each designation with a corrected colspan
                            echo '<tr class="category-row"><td colspan="5">' . $designation . '</td></tr>';
                            
                            // Bind the parameter and execute the prepared statement inside the loop
                            $staffStmt->bind_param("s", $designationRow['current_designation']);
                            $staffStmt->execute();
                            $staffResult = $staffStmt->get_result();

                            if ($staffResult->num_rows > 0) {
                                while ($staffRow = $staffResult->fetch_assoc()) {
                                    echo '<tr class="staff-item">
                                        <td class="staff-name-cell">' . htmlspecialchars($staffRow["official_name"], ENT_QUOTES, 'UTF-8') . '</td>
                                        <td class="staff-designation-cell">' . htmlspecialchars($staffRow["current_designation"], ENT_QUOTES, 'UTF-8') . '</td>
                                        <td>' . htmlspecialchars($staffRow["contact_number"], ENT_QUOTES, 'UTF-8') . '</td>
                                        <td>' . htmlspecialchars($staffRow["address"], ENT_QUOTES, 'UTF-8') . '</td>
                                        <td>' . htmlspecialchars($staffRow["appointment_date"], ENT_QUOTES, 'UTF-8') . '</td>
                                    </tr>';
                                }
                            }
                            $staffResult->close();
                        }
                        $staffStmt->close();
                    } else {
                        // Corrected colspan for the no staff message
                        echo '<tr><td colspan="5" class="text-center" id="noStaffMessage">No staff members found at this time.</td></tr>';
                    }

                    $result->close();
                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function filterStaff() {
        var input = document.getElementById('staffSearch').value.toLowerCase();
        var table = document.getElementById('staffTable');
        var rows = table.querySelectorAll('tbody tr');
        var found = false;
        var categoryRows = table.querySelectorAll('.category-row');
        var noStaffMessage = document.getElementById('noStaffMessage');

        // Hide all category rows initially
        categoryRows.forEach(function(row) {
            row.style.display = 'none';
        });

        rows.forEach(function (row) {
            // Check if the row is a staff member row, not a category row
            if (row.classList.contains('staff-item')) {
                var name = row.querySelector('.staff-name-cell').textContent.toLowerCase();
                var designation = row.querySelector('.staff-designation-cell').textContent.toLowerCase();
                
                if (name.includes(input) || designation.includes(input)) {
                    row.style.display = '';
                    // Find the previous category row and make it visible
                    var prevSibling = row.previousElementSibling;
                    while (prevSibling && !prevSibling.classList.contains('category-row')) {
                        prevSibling = prevSibling.previousElementSibling;
                    }
                    if (prevSibling) {
                        prevSibling.style.display = '';
                    }
                    found = true;
                } else {
                    row.style.display = 'none';
                }
            }
        });

        // This logic handles the "No staff found" message
        if (noStaffMessage) {
            noStaffMessage.style.display = found ? 'none' : '';
        } else if (!found) {
            var noResultsHtml = '<tr id="noStaffMessage"><td colspan="5" class="text-center">No staff members found matching your search.</td></tr>';
            table.querySelector('tbody').insertAdjacentHTML('afterbegin', noResultsHtml);
        }
    }
</script>

<?php
// Include the universal footer
include 'footer.php';
?>