<?php
// Include your database connection
include 'connection.php';

// Get the staff type from the query parameter
$q = $_GET['q'];

// Prepare and execute a safe query
$stmt = $conn->prepare("SELECT `name`, `post`, `details`, `file_location` FROM `staff` WHERE `post` = ? ORDER BY `name` ASC");
$stmt->bind_param("s", $q);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo '<div class="col-lg-4 col-md-6 col-sm-12">
                <div class="staff-card wow fadeInUp" data-wow-delay="0.1s">
                    <img class="staff-img" src="/Administrator/uploads/staff/' . htmlspecialchars($row["file_location"], ENT_QUOTES, 'UTF-8') . '" alt="' . htmlspecialchars($row["name"], ENT_QUOTES, 'UTF-8') . '">
                    <h5 class="staff-name">' . htmlspecialchars($row["name"], ENT_QUOTES, 'UTF-8') . '</h5>
                    <p class="staff-title">' . htmlspecialchars($row["post"], ENT_QUOTES, 'UTF-8') . '</p>
                    <p class="staff-title">' . htmlspecialchars($row["details"], ENT_QUOTES, 'UTF-8') . '</p>
                </div>
              </div>';
    }
} else {
    echo '<div class="col-12">
            <div class="alert alert-info text-center" role="alert">
                <i class="bi bi-info-circle-fill me-2"></i> No staff members found for this category.
            </div>
          </div>';
}

$stmt->close();
$conn->close();
?>